<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblActivityPurposeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblActivityPurpose 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblActivityPurpose primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblActivityPurpose tblActivityPurpose
 	 */
	public function insert($tblActivityPurpose);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblActivityPurpose tblActivityPurpose
 	 */
	public function update($tblActivityPurpose);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPurpose($value);


	public function deleteByPurpose($value);


}
?>