$(function(){
	show();
	seriesLastNum('tbl_hour_code','HC-','#formHourCode','input[name="hour_code_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formHourCode').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveHourCode', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#hour_code_table').on('click','.updateHourCode',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('hourCodeId');
		var hour_code_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var hour_code = $(this).closest('tr').find('td:nth-child(2)').html();
		var description = $(this).closest('tr').find('td:nth-child(3)').html();
		var status = $(this).closest('tr').find('td:nth-child(4)').html();

		$('#updateHourCode').find('input[name="hour_code_id"]').val(id);
		$('#updateHourCode').find('input[name="hour_code_no"]').val(hour_code_no);
		$('#updateHourCode').find('input[name="hour_code"]').val(hour_code);
		$('#updateHourCode').find('input[name="description"]').val(description);

		if(status == 'enabled'){
			$('#updateHourCode').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateHourCode').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateHourCode').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateHourCode', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#hour_code_table');
	$.post(URL+'setup/showHourCode')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.hourCodeNo+"</td>"+
							"<td>"+a.hourCode+"</td>"+
							"<td>"+a.description+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a hourCodeId='"+a.id+"' class='updateHourCode btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.hourCodeData').html(append);
		$('#hour_code_table').DataTable({
			    "ordering": false
		});
	})
}