<?php
/**
 * Class that operate on table 'tbl_daily_forecast'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-05 08:24
 */
class TblDailyForecastMySqlExtDAO extends TblDailyForecastMySqlDAO{

	function getNbtTrans($userId, $date){

		$sql="SELECT 
		   f.forecast_status as fStatus,
		   f.subsync_id as forecastId,
		   ft.subsync_id as forecastTransId,
		   f.user_id,
		   ft.client_id as clientId,
		   ft.engagement_id as engId,
		   ft.tba_id as tbaId,
		   ft.nbt_id as nbtId,
		   ft.rank, ft.target,
		   ft.budget_hrs,
		   ft.to_do_date ,
		   c.`client`,
		   e.engagement,
		   t.tba,
		   n.nbt,
		   df.subsync_id  as `dailyForecastId`,
		   hc.hour_code as dailyHourCode,
		   nbtHours.hours_spent,
		   nbtHours.hour_code,
		   e.`type`,
		   nbtHours.ntId,
		   nbtHours.nhsId,
		   hc.id as hcId,
		   sum(dfpt.target) target,
		   sum(na.quantity) quantity
		   FROM tbl_forecast AS f
		   INNER JOIN tbl_forecast_transaction AS ft
		   ON ft.forecast_id = f.subsync_id
		   INNER JOIN tbl_client as c
		   ON c.id = ft.client_id
		   INNER JOIN tbl_engagement as e
		   ON e.id = ft.engagement_id
		   INNER JOIN tbl_tba as t
		   ON t.id = ft.tba_id
		   INNER JOIN tbl_nbt as n 
		   ON n.id = ft.nbt_id
		   INNER JOIN tbl_daily_forecast df
		   ON df.forecast_transaction_id = ft.subsync_id
		   INNER JOIN tbl_daily_forecast_per_time dfpt
		   ON dfpt.daily_forecast_id = df.subsync_id
		   LEFT JOIN tbl_nbt_actual as na
		   ON na.daily_forecast_per_time_id = dfpt.subsync_id
		   INNER JOIN tbl_hour_code as hc
		   ON hc.id = df.hour_code
		   LEFT JOIN 
		   (
		    SELECT nt.user_id,
		    nt.to_do_date,
		    nhs.daily_forecast_id,
		    nhs.hours_spent,
		    nhs.hour_code,
		    nt.subsync_id as ntId,
		    nhs.subsync_id as nhsId
		    FROM tbl_nbt_transaction as nt
		    INNER JOIN tbl_nbt_hours_spent as nhs
		    ON nhs.nbt_transaction_id = nt.subsync_id
		    WHERE nt.user_id =$userId && nt.to_do_date ='$date'
		   )nbtHours
		   ON nbtHours.daily_forecast_id = df.subsync_id
		   WHERE df.user_id=$userId
		   AND df.to_do_date = '$date'
		   GROUP BY df.subsync_id";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}

	function getNbtTime($userId, $date, $dailyForecastId){

		if($dailyForecastId == '0'){	
			$and = '';
		} else {
			$and = "AND df.subsync_id = '$dailyForecastId'";
		}

		$sql="SELECT
		tnt.id nbtTimeId,
		tnt.description,
		trans.dfptId,
		trans.dfId,
		trans.forecast_transaction_id,
		trans.dfptId,
		IF(trans.dfptId IS NULL, 0,
		IF(nbtHrs.quantity IS NOT NULL, nbtHrs.quantity,'x')
		) as quantity,
		nbtHrs.nbtActualId,
		trans.dailyForecastPerTimeId
		FROM
			tbl_nbt_time tnt
		LEFT JOIN
		(
		SELECT dfpt.nbt_time_id,
		dfpt.subsync_id as dfptId,
		df.subsync_id as dfId,
		df.forecast_transaction_id,
		df.user_id,
		df.to_do_date,
		dfpt.id as dailyForecastPerTimeId
		FROM tbl_daily_forecast_per_time dfpt
		INNER JOIN tbl_daily_forecast df
		ON df.subsync_id = dfpt.daily_forecast_id
		INNER JOIN tbl_nbt_time nt
		ON nt.id = dfpt.nbt_time_id
		WHERE nt.`from` >= '8:00:00' && nt.`to` <= '24:00:00'
		$and
		AND df.user_id=$userId
		AND df.to_do_date= '$date'
		) trans
		ON trans.nbt_time_id = tnt.id
		LEFT JOIN (
			
			SELECT na.daily_forecast_per_time_id dfpt2Id,
			na.quantity,
			na.subsync_id as nbtActualId
			FROM tbl_nbt_actual as na
			INNER JOIN tbl_daily_forecast_per_time as dfpt2
			On dfpt2.subsync_id = na.daily_forecast_per_time_id
		
		) nbtHrs
		ON nbtHrs.dfpt2Id = trans.dfptId
		WHERE tnt.`from` >= '8:00:00' && tnt.`to` <= '24:00:00'
		ORDER BY tnt.id";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
}
?>