<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblDprecordsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDprecords 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDprecord primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDprecords tblDprecord
 	 */
	public function insert($tblDprecord);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDprecords tblDprecord
 	 */
	public function update($tblDprecord);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTransId($value);

	public function queryByActivity($value);

	public function queryByCategory($value);

	public function queryByPlannedOutput($value);

	public function queryByActualOutput($value);

	public function queryByToDos($value);

	public function queryByTaskIssue($value);

	public function queryByCompletionAge($value);

	public function queryByLineProperty($value);

	public function queryByTimeStart($value);

	public function queryByTimeEnd($value);

	public function queryByHourSpent($value);

	public function queryByHourCode($value);

	public function queryByJournal($value);

	public function queryByVoucher($value);

	public function queryByTransaction($value);


	public function deleteByTransId($value);

	public function deleteByActivity($value);

	public function deleteByCategory($value);

	public function deleteByPlannedOutput($value);

	public function deleteByActualOutput($value);

	public function deleteByToDos($value);

	public function deleteByTaskIssue($value);

	public function deleteByCompletionAge($value);

	public function deleteByLineProperty($value);

	public function deleteByTimeStart($value);

	public function deleteByTimeEnd($value);

	public function deleteByHourSpent($value);

	public function deleteByHourCode($value);

	public function deleteByJournal($value);

	public function deleteByVoucher($value);

	public function deleteByTransaction($value);


}
?>