<?php
/**
 * Class that operate on table 'tbl_subordinate'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-01-12 03:15
 */
class TblSubordinateMySqlDAO implements TblSubordinateDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblSubordinateMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_subordinate WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_subordinate';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_subordinate ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblSubordinate primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_subordinate WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblSubordinateMySql tblSubordinate
 	 */
	public function insert($tblSubordinate){
		$sql = 'INSERT INTO tbl_subordinate (superior_id, subordinate_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblSubordinate->superiorId);
		$sqlQuery->setNumber($tblSubordinate->subordinateId);
		$sqlQuery->setNumber($tblSubordinate->createdBy);
		$sqlQuery->setNumber($tblSubordinate->modifiedBy);
		$sqlQuery->set($tblSubordinate->dateCreated);
		$sqlQuery->set($tblSubordinate->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblSubordinate->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblSubordinateMySql tblSubordinate
 	 */
	public function update($tblSubordinate){
		$sql = 'UPDATE tbl_subordinate SET superior_id = ?, subordinate_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblSubordinate->superiorId);
		$sqlQuery->setNumber($tblSubordinate->subordinateId);
		$sqlQuery->setNumber($tblSubordinate->createdBy);
		$sqlQuery->setNumber($tblSubordinate->modifiedBy);
		$sqlQuery->set($tblSubordinate->dateCreated);
		$sqlQuery->set($tblSubordinate->dateModified);

		$sqlQuery->setNumber($tblSubordinate->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_subordinate';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySuperiorId($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE superior_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubordinateId($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE subordinate_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_subordinate WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySuperiorId($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE superior_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubordinateId($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE subordinate_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_subordinate WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblSubordinateMySql 
	 */
	protected function readRow($row){
		$tblSubordinate = new TblSubordinate();
		
		$tblSubordinate->id = $row['id'];
		$tblSubordinate->superiorId = $row['superior_id'];
		$tblSubordinate->subordinateId = $row['subordinate_id'];
		$tblSubordinate->createdBy = $row['created_by'];
		$tblSubordinate->modifiedBy = $row['modified_by'];
		$tblSubordinate->dateCreated = $row['date_created'];
		$tblSubordinate->dateModified = $row['date_modified'];

		return $tblSubordinate;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblSubordinateMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>