<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-13 14:52
 */
interface TblUserModuleAccessDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUserModuleAccess 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUserModuleAcces primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserModuleAccess tblUserModuleAcces
 	 */
	public function insert($tblUserModuleAcces);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserModuleAccess tblUserModuleAcces
 	 */
	public function update($tblUserModuleAcces);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByModuleId($value);

	public function queryByUserId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateModified($value);

	public function queryByDateCreated($value);


	public function deleteByModuleId($value);

	public function deleteByUserId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateModified($value);

	public function deleteByDateCreated($value);


}
?>