<?php
	$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
	list($year,$month) = explode('-',$date);
	$week1 = date('w',strtotime($year.'-'.$month.'-01'));
	$month = dateNumber($month);

	$days = cal_days_in_month(CAL_GREGORIAN, $month, $year);

	function dateNumber($int)
	{
		if(strlen($int) == 1)
		{
			return '0'.$int;
		} else 
		{
			return $int;
		}
	}
?>
<style>
	.calendar > tr > td > span.calendar-working-day{
		font-size: 10px;
		font-weight: bolder;
		background: #21bc5a	;
		padding: 3px;
		border-radius: 2px;
		color: #fff;
		margin: 5px auto;
		display: block;
		text-align: center;
	}
	.calendar > tr > td > span.calendar-working-time{
		font-size: 10px;
		font-weight: bolder;
		background: #f44336;
		padding: 3px;
		border-radius: 2px;
		color: #fff;
		margin: 5px auto;
		display: block;
		text-align: center;
	}
	.btn-circle {
		width: 26px;
    	height: 26px;
	    text-align: center;
	    padding: 5px 5px;
	    font-size: 12px;
	    line-height: 1.428571429;
	    border-radius: 15px;
		}
	.showWorkingType{
		font-size: 18px; 
		padding: 10px; 
		background: #5bc0de; 
		color: #fff
	}
	.showTime{
		font-size: 12px;
		padding: 7px 11px;
		background: #f1f1f1;
		border-left: 1px solid #ddd;
		border-right: 1px solid #ddd;
		color: #585858;
	}
	.showRemarks{
		font-size: 15px;
		padding: 20px;
		background: #fff;
		border: 1px solid #ddd;
		height: 380px;
		overflow-y: scroll;
	}
</style>
<div class="box-standard">
	<div class="row mt-8">
		<div class="col-lg-6 col-xs-12 col-sm-12 text-left">
			<div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> Calendar</div>
		</div>
		<div class="col-lg-6 col-xs-12 col-sm-12 text-right">
			<!-- <div class="page-header-buttons-standard-left"> -->
				<!-- <div class="col-lg-9"> -->
					<!-- <div class="success bold-text btn-pad page-header-text-box" style="width: 50%"><i class="pe-7s-date pe-lg"></i> <?= date('F Y')?></div> -->
				<!-- </div> -->
				<!-- <div class="col-lg-3 text-right"> -->
					<a href="<?=URL?>calendar?date=<?=date('Y-m-d',strtotime($date.'-1 month'))?>"><button type="button" class="btn btn-success" style="padding: 10px"> <i class="pe-7s-angle-left-circle pe-lg"></i></button></a>
					<a href="<?=URL?>calendar?date=<?=date('Y-m-d',strtotime($date.' +1 month'))?>"><button type="button" class="btn btn-success" style="padding: 10px"> <i class="pe-7s-angle-right-circle pe-lg"></i></button></a>
				<!-- </div> -->
			<!-- </div> -->
		</div>
	</div>
</div>
<div class="box-standard">
	<div class="row mt-8">
		<div class="col-lg-12">
			<div class="col-lg-4">
				<div class="page-header-buttons-standard-right">
					<div class="success bold-text btn-pad page-header-text-box"><i class="pe-7s-date pe-lg"></i> <?= date('F Y', strtotime($date))?></div>
				</div>
			</div>
			<div class="col-lg-8">
				<div class="page-header-buttons-standard-left">
				</div>
			</div>
		</div>
	</div><hr>
	<div class="row">
		<div class="col-lg-12">
			<div class="col-lg-12">
				<div class="table-responsive">
					<table class="table table-standard table-bordered" style="height: 500px;">
						<thead>
							<tr>
								<th style="width:14.30%" class="text-center">Sun</th>
								<th style="width:14.30%" class="text-center">Mon</th>
								<th style="width:14.30%" class="text-center">Tue</th>
								<th style="width:14.30%" class="text-center">Wed</th>
								<th style="width:14.30%" class="text-center">Thu</th>
								<th style="width:14.30%" class="text-center">Fri</th>
								<th style="width:14.30%" class="text-center">Sat</th>
							</tr>
						</thead>
						<tbody class="calendar">
							<?php $day = 1;?>
							<tr>
								<?php for($i = 0; $i < 7; $i++):
										if($week1 > $i):?>
											<td></td>
									<?php else: ?>
											<td>
												<?= showWorkingCalendar($month,$year,$day); ?>
											</td>
									<?php $day++; ?>
									<?php endif; ?>
								<?php endfor; ?>
							</tr>
							<?php $day--;?>
								<?php for($p = 1; $p < weeks_in_month($month, $year); $p++):?>
								<tr>
									<?php for($d = 1; $d <= 7; $d++):?>
										<?php if($day!=$days): $day++; ?>
											<td>
												<?= showWorkingCalendar($month,$year,$day); ?>
											</td>
										<?php else: ?>
											<td></td>
										<?php endif; ?>
									<?php endfor; ?>
								</tr>
								<?php endfor; ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<form method="post" id="formAddEvent">
	<div id="sampleModal" class="modal fade" role="dialog">
		<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title"><i class="pe-7s-date pe-lg"></i> Add Event</h4>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group">
						<div class="col-lg-12">
							Date: 
							<input type="text" class="form-control" readonly name="date">
						</div>
					</div>
					<div class="form-group">
						<div class="col-lg-12 mt-10">
							Working Type: 
							<select type="text" name="workingType" data-live-search="true" class="form-control selectpicker" required="">
								<option selected disabled></option>
								<option value="regular">Regular</option>
								<option value="holiday">Holiday</option>
								<option value="restday">Restday</option>
							</select>
						</div>
					</div>
					<div class="form-group holiday" style="display: none">
						<div class="col-lg-12 mt-10">
							Holiday: 
							<select type="text" name="holiday" data-live-search="true" class="form-control selectpicker">
							</select>
						</div>
					</div>
					<div class="form-group fromTime" style="display: none">
						<div class="col-lg-6 mt-10">
							From: 
							<div class="input-group bootstrap-timepicker timepicker">
						        <input class="form-control input-small timepicker1" name="fromTime" type="text" value="8:00 AM" required="">
						        <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
						    </div>
						</div>
						<div class="col-lg-6 mt-10">
							To: 
							<div class="input-group bootstrap-timepicker timepicker">
						        <input class="form-control input-small timepicker1" name="toTime" type="text" value="6:00 PM" required="">
						        <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
						    </div>
						</div>
					</div>
					<!-- <div class="form-group toTime" style="display: none">
					</div> -->
					<div class="form-group">
						<div class="col-lg-12 mt-10">
							Remarks: 
							<textarea class="form-control" rows="6" name="remarks"></textarea>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success">Save</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>

		</div>
	</div>
</form>
<form method="post" id="formUpdateEvent">
	<div id="updateModal" class="modal fade" role="dialog">
		<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title"><i class="pe-7s-date pe-lg"></i> Update Event</h4>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group">
						<div class="col-lg-12">
							Date: 
							<input type="text" class="form-control" readonly name="date">
						</div>
					</div>
					<div class="form-group">
						<div class="col-lg-12 mt-10">
							Working Type: 
							<select type="text" name="workingType" data-live-search="true" class="form-control selectpicker" required="">
								<option selected disabled></option>
								<option value="regular">Regular</option>
								<option value="holiday">Holiday</option>
								<option value="restday">Restday</option>
							</select>
						</div>
					</div>
					<div class="form-group holiday" style="display: none">
						<div class="col-lg-12 mt-10">
							Holiday: 
							<?php $holiday = DAOFactory::getTblHolidayDAO()->queryAll();?>
							<select type="text" name="holiday" data-live-search="true" class="form-control selectpicker">
							<?php foreach ($holiday as $key => $value): ?>
								<option value="<?=$value->id?>"><?=$value->holiday?></option>
							<?php endforeach?>
							</select>
						</div>
					</div>
					<div class="form-group fromTime" style="display: none">
						<div class="col-lg-6 mt-10">
							From: 
							<div class="input-group bootstrap-timepicker timepicker">
						        <input class="form-control input-small timepicker1" name="fromTime" type="text" required="">
						        <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
						    </div>
						</div>
						<div class="col-lg-6 mt-10">
							To: 
							<div class="input-group bootstrap-timepicker timepicker">
						        <input class="form-control input-small timepicker1" name="toTime" type="text" required="">
						        <span class="input-group-addon"><i class="glyphicon glyphicon-time"></i></span>
						    </div>
						</div>
					</div>
					<!-- <div class="form-group toTime" style="display: none">
					</div> -->
					<div class="form-group">
						<div class="col-lg-12 mt-10">
							Remarks: 
							<textarea class="form-control" rows="6" name="remarks"></textarea>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="submit" class="btn btn-success">Save</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>

		</div>
	</div>
</form>
<div id="showInfo" class="modal fade" role="dialog">
	<div class="modal-dialog modal-lg">
	<div class="modal-content">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title"><i class="pe-7s-date pe-lg"></i> <span class="titleDate"></span></h4>
		</div>
		<div class="modal-body">
			<div class="showWorkingType"></div>
			<div class="showTime"></div>
			<div class="showRemarks"></div>
		</div>
	</div>

	</div>
</div>
<?php 

	function weeks_in_month($month, $year) {
		 $start = mktime(0, 0, 0, $month, 1, $year);
		 $end = mktime(0, 0, 0, $month, date('t', $start), $year);
		 $start_week = date('W', $start);
		 $end_week = date('W', $end);
		 
		 if ($end_week < $start_week) {
		   return ((52 + $end_week) - $start_week) + 1;
		 }
		 
		 return ($end_week - $start_week) + 1;
	}
	function showWorkingCalendar($month, $year,$day) {

		$date = $year.'-'.$month.'-'.str_pad($day, 2, '0', STR_PAD_LEFT);
		$dateToday = date('Y-m-d');
		$checkWeekEnd = date('N', strtotime($date)) >= 6;
		// $dateRegistered = date('Y-m-d', strtotime($_SESSION['user']['dateCreated']));

		$check = DAOFactory::getTblWorkingCalendarDAO()->queryByWorkingDate($date);
		if(empty($check)){
			echo '<span class="calendar-day">'. str_pad($day, 2, '0', STR_PAD_LEFT) .'</span> <br> 
				<span class="calendar-working-day">No Event</span> <br><br>
				<span style="float:right;">
					<button class="btn btn-success btn-circle btnAddEvent"> <i class="pe-7s-plus pe-lg"></i></button></span>
				';
		} else {

			$viewRemarks = '';
			$workingTime = '<br><br>';
			$workingDay = $check[0]->workingType == 'regular' ? 'Regular Working Day' : ($check[0]->workingType == 'holiday' ?  'Holiday' : 'Rest Day');
			if($check[0]->remarks != ''){
				$viewRemarks = '<span style="float:left;">
					<button class="btn btn-info btn-circle btnViewRemarks" > <i class="pe-7s-look pe-lg"></i></button>
				</span>';
			}			
			if($check[0]->workingType != 'restday'){
				$workingTime = '<span class="calendar-working-time">'.date('h:i A', strtotime($check[0]->fromTime)).'-'.date('h:i A', strtotime($check[0]->toTime)).'</span><br>';
			}
			echo '
				<span class="calendar-day">'. str_pad($day, 2, '0', STR_PAD_LEFT) .'</span> <br> 
				<span class="calendar-working-day">'.$workingDay.'</span>'
				.$workingTime.
				'<span style="float:right;">
					<button class="btn btn-warning btn-circle btnUpdateEvent"> <i class="pe-7s-note pe-lg"></i></button></span>'.$viewRemarks;
		}
		// print_r($check);
	}

?>

<script>
	var year = "<?=$year?>";
	var month = "<?=$month?>";
	$(function(){
		$('textarea[name="remarks"]').ckeditor();
		
		$('#formAddEvent').submit(function(){
			var form = $(this).serialize();
			saveAlert('You want to save this event?',function(){
				$.post(URL+'calendar/addEvent',form)
				.done(function(returnData){
					location.reload(); 
				})
				return false;
			})
			return false;
			
		})
		$('#formUpdateEvent').submit(function(){
			var form = $(this).serialize();
			saveAlert('You want to update this event?',function(){
				$.post(URL+'calendar/updateEvent',form)
				.done(function(returnData){
					location.reload();
				})
				return false;
			})
			return false;
			
		})
		$('.btnAddEvent').click(function(){
			getHoliday()
			var day = $(this).closest('td').find('span.calendar-day').html();
			var date = year+'-'+month+'-'+day;
			$('#sampleModal').modal('toggle');
			$('#formAddEvent').find('input[name="date"]').val(date);
		})
		$('.btnUpdateEvent').click(function(){
			var day = $(this).closest('td').find('span.calendar-day').html();
			var date = year+'-'+month+'-'+day;
			selectDate(date);
		})
		$('.btnViewRemarks').click(function(){
			var day = $(this).closest('td').find('span.calendar-day').html();
			var date = year+'-'+month+'-'+day;
			getEvent(date);
		})
		$('select[name="workingType"]').change(function(){
		 	var val = $(this).val();
			if(val=='regular'){
				$('.totalHours').show();
				$('.holiday').hide();
				$('.fromTime').show();
				$('.toTime').show();
			} else if(val=='holiday'){
				$('.totalHours').hide();
				$('.holiday').show();
				$('.fromTime').show();
				$('.toTime').show();
			} else{
				$('.holiday').hide();
				$('.fromTime').hide();
				$('.toTime').hide();
			}
		})

	})
	function getHoliday(){
		$.post(URL+'calendar/showHoliday')
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '';
			$.each(data, function(key,a){
				append += '<option value="'+a.id+'">'+a.holiday+'</option>';
			})
			$('#formAddEvent').find('select[name="holiday"]').html(append);
			$('#formAddEvent').find('select[name="holiday"]').selectpicker('refresh');

		})
	}
	function selectDate(date){
		$.post(URL+'calendar/getEventByDate',{"date":date})
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			$('#formUpdateEvent').find('input[name="date"]').val(date);
			$('#formUpdateEvent').find('select[name="holiday"]').val(data[0].holidayId).trigger('change');
			$('#formUpdateEvent').find('select[name="workingType"]').val(data[0].workingType).trigger('change');
			$('#formUpdateEvent').find('input[name="fromTime"]').val(tConvert(data[0].fromTime));
			$('#formUpdateEvent').find('input[name="toTime"]').val(tConvert(data[0].toTime));
			$('#formUpdateEvent').find('textarea[name="remarks"]').val(data[0].remarks);
			if(data[0].workingType=='regular'){
				$('.totalHours').show();
				$('.holiday').hide();
				$('.fromTime').show();
				$('.toTime').show();
			} else if(data[0].workingType=='holiday'){
				$('.totalHours').hide();
				$('.holiday').show();
				$('.fromTime').show();
				$('.toTime').show();
			} else{
				$('.holiday').hide();
				$('.fromTime').hide(); 
				$('.toTime').hide();

			}
			$('#updateModal').modal({
			  	backdrop: 'static', 
			   	keyboard: false,
			   	toggle: true
			});

		})
	}
	function getEvent(date){
		$.post(URL+'calendar/getEventByDateHoliday',{'date':date})
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			if(data[0].remarks!=''){
				var monthNames = ["","January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
				var wdayTitle = (data[0].working_type == "regular") ? data[0].working_type.toUpperCase()+' WORKING DAY' : ((data[0].working_type == "holiday") ? data[0].working_type.toUpperCase()+' ('+data[0].holiday+')' : data[0].working_type.toUpperCase());
				var wTimeTitle = (data[0].working_type == "regular" || data[0].working_type == "holiday") ? tConvert(data[0].fromTime)+' - '+tConvert(data[0].toTime) : '';
				var month = monthNames[Number(date.split('-')[1]).toString()];
				var day = date.split('-')[2];
				var year = date.split('-')[0];
				$('.titleDate').html(month+' '+day+', '+year);
				$('.showWorkingType').html(wdayTitle);
				$('.showTime').html(wTimeTitle);
				$('.showRemarks').html(data[0].remarks);
				$('#showInfo').modal({
				  	backdrop: 'static', 
				    keyboard: false,
				    toggle: true
				});
			}
		})
	}
	function tConvert(time) {
	  // Check correct time format and split into components
	  time = time.toString ().match (/^([01]\d|2[0-3])(:)([0-5]\d)(:[0-5]\d)?$/) || [time];

	  if (time.length > 1) { // If time format correct
	    time = time.slice (1);  // Remove full string match value
	    time[5] = +time[0] < 12 ? ' AM' : ' PM'; // Set AM/PM
	    time[0] = +time[0] % 12 || 12; // Adjust hours
	  }
	  return time.join (''); // return adjusted time or original string
	}
</script>