$(function(){
	show();
	countTable('setup/countLeave','LVE-','#formLeave','input[name="leave_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formLeave').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveLeave', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#leave_table').on('click','.updateLeave',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('leaveId');
		var leave_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var leave = $(this).closest('tr').find('td:nth-child(2)').html();
		var code = $(this).closest('tr').find('td:nth-child(3)').html();
		var status = $(this).closest('tr').find('td:nth-child(4)').html();

		$('#updateLeave').find('input[name="leave_id"]').val(id);
		$('#updateLeave').find('input[name="leave_no"]').val(leave_no);
		$('#updateLeave').find('input[name="leave"]').val(leave);
		$('#updateLeave').find('input[name="code"]').val(code);

		if(status == 'enabled'){
			$('#updateLeave').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateLeave').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateLeave').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateLeave', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#leave_table');
	$.post(URL+'setup/showLeave')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.leaveNo+"</td>"+
							"<td>"+a.leave+"</td>"+
							"<td>"+a.code+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a leaveId='"+a.id+"' class='updateLeave btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.leaveData').html(append);
		$('#leave_table').DataTable({
			    "ordering": false
		});
	})
}