<?php
/**
 * Class that operate on table 'tbl_pbs'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblPbsMySqlDAO implements TblPbsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblPbsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_pbs WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_pbs';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_pbs ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblPb primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_pbs WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPbsMySql tblPb
 	 */
	public function insert($tblPb){
		$sql = 'INSERT INTO tbl_pbs (subsync_id, subdomain, user_id, client_id, pbs_date, greet_client, client_greet, provide_communication, reply_communication, exercise_humility, content_name, email_address, subject, message, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPb->subsyncId);
		$sqlQuery->setNumber($tblPb->subdomain);
		$sqlQuery->setNumber($tblPb->userId);
		$sqlQuery->setNumber($tblPb->clientId);
		$sqlQuery->set($tblPb->pbsDate);
		$sqlQuery->set($tblPb->greetClient);
		$sqlQuery->set($tblPb->clientGreet);
		$sqlQuery->set($tblPb->provideCommunication);
		$sqlQuery->set($tblPb->replyCommunication);
		$sqlQuery->set($tblPb->exerciseHumility);
		$sqlQuery->set($tblPb->contentName);
		$sqlQuery->set($tblPb->emailAddress);
		$sqlQuery->set($tblPb->subject);
		$sqlQuery->set($tblPb->message);
		$sqlQuery->setNumber($tblPb->createdBy);
		$sqlQuery->setNumber($tblPb->modifiedBy);
		$sqlQuery->set($tblPb->dateCreated);
		$sqlQuery->set($tblPb->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblPb->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPbsMySql tblPb
 	 */
	public function update($tblPb){
		$sql = 'UPDATE tbl_pbs SET subsync_id = ?, subdomain = ?, user_id = ?, client_id = ?, pbs_date = ?, greet_client = ?, client_greet = ?, provide_communication = ?, reply_communication = ?, exercise_humility = ?, content_name = ?, email_address = ?, subject = ?, message = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPb->subsyncId);
		$sqlQuery->setNumber($tblPb->subdomain);
		$sqlQuery->setNumber($tblPb->userId);
		$sqlQuery->setNumber($tblPb->clientId);
		$sqlQuery->set($tblPb->pbsDate);
		$sqlQuery->set($tblPb->greetClient);
		$sqlQuery->set($tblPb->clientGreet);
		$sqlQuery->set($tblPb->provideCommunication);
		$sqlQuery->set($tblPb->replyCommunication);
		$sqlQuery->set($tblPb->exerciseHumility);
		$sqlQuery->set($tblPb->contentName);
		$sqlQuery->set($tblPb->emailAddress);
		$sqlQuery->set($tblPb->subject);
		$sqlQuery->set($tblPb->message);
		$sqlQuery->setNumber($tblPb->createdBy);
		$sqlQuery->setNumber($tblPb->modifiedBy);
		$sqlQuery->set($tblPb->dateCreated);
		$sqlQuery->set($tblPb->dateModified);

		$sqlQuery->setNumber($tblPb->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_pbs';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPbsDate($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE pbs_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByGreetClient($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE greet_client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientGreet($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE client_greet = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProvideCommunication($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE provide_communication = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReplyCommunication($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE reply_communication = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExerciseHumility($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE exercise_humility = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContentName($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE content_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEmailAddress($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE email_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubject($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE subject = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMessage($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE message = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_pbs WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_pbs WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_pbs WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_pbs WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientId($value){
		$sql = 'DELETE FROM tbl_pbs WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPbsDate($value){
		$sql = 'DELETE FROM tbl_pbs WHERE pbs_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByGreetClient($value){
		$sql = 'DELETE FROM tbl_pbs WHERE greet_client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientGreet($value){
		$sql = 'DELETE FROM tbl_pbs WHERE client_greet = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProvideCommunication($value){
		$sql = 'DELETE FROM tbl_pbs WHERE provide_communication = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReplyCommunication($value){
		$sql = 'DELETE FROM tbl_pbs WHERE reply_communication = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExerciseHumility($value){
		$sql = 'DELETE FROM tbl_pbs WHERE exercise_humility = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContentName($value){
		$sql = 'DELETE FROM tbl_pbs WHERE content_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEmailAddress($value){
		$sql = 'DELETE FROM tbl_pbs WHERE email_address = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubject($value){
		$sql = 'DELETE FROM tbl_pbs WHERE subject = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMessage($value){
		$sql = 'DELETE FROM tbl_pbs WHERE message = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_pbs WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_pbs WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_pbs WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_pbs WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblPbsMySql 
	 */
	protected function readRow($row){
		$tblPb = new TblPb();
		
		$tblPb->id = $row['id'];
		$tblPb->subsyncId = $row['subsync_id'];
		$tblPb->subdomain = $row['subdomain'];
		$tblPb->userId = $row['user_id'];
		$tblPb->clientId = $row['client_id'];
		$tblPb->pbsDate = $row['pbs_date'];
		$tblPb->greetClient = $row['greet_client'];
		$tblPb->clientGreet = $row['client_greet'];
		$tblPb->provideCommunication = $row['provide_communication'];
		$tblPb->replyCommunication = $row['reply_communication'];
		$tblPb->exerciseHumility = $row['exercise_humility'];
		$tblPb->contentName = $row['content_name'];
		$tblPb->emailAddress = $row['email_address'];
		$tblPb->subject = $row['subject'];
		$tblPb->message = $row['message'];
		$tblPb->createdBy = $row['created_by'];
		$tblPb->modifiedBy = $row['modified_by'];
		$tblPb->dateCreated = $row['date_created'];
		$tblPb->dateModified = $row['date_modified'];

		return $tblPb;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblPbsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>