<?php
/**
 * Class that operate on table 'tbl_nbt_time'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblNbtTimeMySqlDAO implements TblNbtTimeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblNbtTimeMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_nbt_time';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_nbt_time ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblNbtTime primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_nbt_time WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtTimeMySql tblNbtTime
 	 */
	public function insert($tblNbtTime){
		$sql = 'INSERT INTO tbl_nbt_time (nbt_time_no, `from`, `to`, description, status, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblNbtTime->nbtTimeNo);
		$sqlQuery->set($tblNbtTime->from);
		$sqlQuery->set($tblNbtTime->to);
		$sqlQuery->set($tblNbtTime->description);
		$sqlQuery->set($tblNbtTime->status);
		$sqlQuery->setNumber($tblNbtTime->createdBy);
		$sqlQuery->setNumber($tblNbtTime->modifiedBy);
		$sqlQuery->set($tblNbtTime->dateCreated);
		$sqlQuery->set($tblNbtTime->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblNbtTime->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtTimeMySql tblNbtTime
 	 */
	public function update($tblNbtTime){
		$sql = 'UPDATE tbl_nbt_time SET nbt_time_no = ?, `from` = ?, `to` = ?, description = ?, status = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblNbtTime->nbtTimeNo);
		$sqlQuery->set($tblNbtTime->from);
		$sqlQuery->set($tblNbtTime->to);
		$sqlQuery->set($tblNbtTime->description);
		$sqlQuery->set($tblNbtTime->status);
		$sqlQuery->setNumber($tblNbtTime->createdBy);
		$sqlQuery->setNumber($tblNbtTime->modifiedBy);
		$sqlQuery->set($tblNbtTime->dateCreated);
		$sqlQuery->set($tblNbtTime->dateModified);

		$sqlQuery->setNumber($tblNbtTime->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_nbt_time';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByNbtTimeNo($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE nbt_time_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFrom($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE from = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTo($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE to = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDescription($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_nbt_time WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByNbtTimeNo($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE nbt_time_no = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFrom($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE from = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTo($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE to = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDescription($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_nbt_time WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblNbtTimeMySql 
	 */
	protected function readRow($row){
		$tblNbtTime = new TblNbtTime();
		
		$tblNbtTime->id = $row['id'];
		$tblNbtTime->nbtTimeNo = $row['nbt_time_no'];
		$tblNbtTime->from = $row['from'];
		$tblNbtTime->to = $row['to'];
		$tblNbtTime->description = $row['description'];
		$tblNbtTime->status = $row['status'];
		$tblNbtTime->createdBy = $row['created_by'];
		$tblNbtTime->modifiedBy = $row['modified_by'];
		$tblNbtTime->dateCreated = $row['date_created'];
		$tblNbtTime->dateModified = $row['date_modified'];

		return $tblNbtTime;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblNbtTimeMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>