<?php
/**
 * Class that operate on table 'tbl_budget_hours_per_position'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblBudgetHoursPerPositionMySqlDAO implements TblBudgetHoursPerPositionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblBudgetHoursPerPositionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblBudgetHoursPerPosition primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_budget_hours_per_position WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblBudgetHoursPerPositionMySql tblBudgetHoursPerPosition
 	 */
	public function insert($tblBudgetHoursPerPosition){
		$sql = 'INSERT INTO tbl_budget_hours_per_position (engagement_setup_id, position_id, budget_hours, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblBudgetHoursPerPosition->engagementSetupId);
		$sqlQuery->setNumber($tblBudgetHoursPerPosition->positionId);
		$sqlQuery->set($tblBudgetHoursPerPosition->budgetHours);
		$sqlQuery->setNumber($tblBudgetHoursPerPosition->createdBy);
		$sqlQuery->setNumber($tblBudgetHoursPerPosition->modifiedBy);
		$sqlQuery->set($tblBudgetHoursPerPosition->dateCreated);
		$sqlQuery->set($tblBudgetHoursPerPosition->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblBudgetHoursPerPosition->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblBudgetHoursPerPositionMySql tblBudgetHoursPerPosition
 	 */
	public function update($tblBudgetHoursPerPosition){
		$sql = 'UPDATE tbl_budget_hours_per_position SET engagement_setup_id = ?, position_id = ?, budget_hours = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblBudgetHoursPerPosition->engagementSetupId);
		$sqlQuery->setNumber($tblBudgetHoursPerPosition->positionId);
		$sqlQuery->set($tblBudgetHoursPerPosition->budgetHours);
		$sqlQuery->setNumber($tblBudgetHoursPerPosition->createdBy);
		$sqlQuery->setNumber($tblBudgetHoursPerPosition->modifiedBy);
		$sqlQuery->set($tblBudgetHoursPerPosition->dateCreated);
		$sqlQuery->set($tblBudgetHoursPerPosition->dateModified);

		$sqlQuery->setNumber($tblBudgetHoursPerPosition->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_budget_hours_per_position';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByEngagementSetupId($value){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position WHERE engagement_setup_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPositionId($value){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position WHERE position_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBudgetHours($value){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position WHERE budget_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_budget_hours_per_position WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByEngagementSetupId($value){
		$sql = 'DELETE FROM tbl_budget_hours_per_position WHERE engagement_setup_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPositionId($value){
		$sql = 'DELETE FROM tbl_budget_hours_per_position WHERE position_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBudgetHours($value){
		$sql = 'DELETE FROM tbl_budget_hours_per_position WHERE budget_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_budget_hours_per_position WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_budget_hours_per_position WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_budget_hours_per_position WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_budget_hours_per_position WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblBudgetHoursPerPositionMySql 
	 */
	protected function readRow($row){
		$tblBudgetHoursPerPosition = new TblBudgetHoursPerPosition();
		
		$tblBudgetHoursPerPosition->id = $row['id'];
		$tblBudgetHoursPerPosition->engagementSetupId = $row['engagement_setup_id'];
		$tblBudgetHoursPerPosition->positionId = $row['position_id'];
		$tblBudgetHoursPerPosition->budgetHours = $row['budget_hours'];
		$tblBudgetHoursPerPosition->createdBy = $row['created_by'];
		$tblBudgetHoursPerPosition->modifiedBy = $row['modified_by'];
		$tblBudgetHoursPerPosition->dateCreated = $row['date_created'];
		$tblBudgetHoursPerPosition->dateModified = $row['date_modified'];

		return $tblBudgetHoursPerPosition;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblBudgetHoursPerPositionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>