<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblDepartmentPerCompanyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDepartmentPerCompany 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDepartmentPerCompany primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDepartmentPerCompany tblDepartmentPerCompany
 	 */
	public function insert($tblDepartmentPerCompany);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDepartmentPerCompany tblDepartmentPerCompany
 	 */
	public function update($tblDepartmentPerCompany);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompanyId($value);

	public function queryByDepartmentId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByCompanyId($value);

	public function deleteByDepartmentId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>