<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-05-27 08:17
 */
interface TblClientWinDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblClientWin 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblClientWin primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientWin tblClientWin
 	 */
	public function insert($tblClientWin);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientWin tblClientWin
 	 */
	public function update($tblClientWin);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientNewId($value);

	public function queryByKeyAccountsId($value);

	public function queryByClientWinNo($value);

	public function queryByAmount($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByClientNewId($value);

	public function deleteByKeyAccountsId($value);

	public function deleteByClientWinNo($value);

	public function deleteByAmount($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>