<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblEmployeeSetupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblEmployeeSetup 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblEmployeeSetup primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEmployeeSetup tblEmployeeSetup
 	 */
	public function insert($tblEmployeeSetup);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEmployeeSetup tblEmployeeSetup
 	 */
	public function update($tblEmployeeSetup);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmployee($value);

	public function queryByShift($value);

	public function queryByTimeIn($value);

	public function queryByTimeOut($value);

	public function queryByNholiday($value);

	public function queryByRMon($value);

	public function queryByRTue($value);

	public function queryByRWed($value);

	public function queryByRThu($value);

	public function queryByRFri($value);

	public function queryByRSat($value);

	public function queryByRSun($value);

	public function queryByAlternate($value);

	public function queryByClient($value);

	public function queryByDate($value);


	public function deleteByEmployee($value);

	public function deleteByShift($value);

	public function deleteByTimeIn($value);

	public function deleteByTimeOut($value);

	public function deleteByNholiday($value);

	public function deleteByRMon($value);

	public function deleteByRTue($value);

	public function deleteByRWed($value);

	public function deleteByRThu($value);

	public function deleteByRFri($value);

	public function deleteByRSat($value);

	public function deleteByRSun($value);

	public function deleteByAlternate($value);

	public function deleteByClient($value);

	public function deleteByDate($value);


}
?>