$(function(){
	show();
	countTable('setup/countTBA','TBA-','#formTBA','input[name="tba_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formTBA').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveTBA', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#tba_table').on('click','.updateTBA',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('tbaId');
		var tba_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var tba_name = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateTBA').find('input[name="tba_id"]').val(id);
		$('#updateTBA').find('input[name="tba_no"]').val(tba_no);
		$('#updateTBA').find('input[name="tba_name"]').val(tba_name);

		if(status == 'enabled'){
			$('#updateTBA').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateTBA').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$("#updateTBA").submit(function(){
		var data = $(this).serialize();
		$.post(URL+'setup/updateTBA',data)
		.done(function(returnData){
			if(returnData == ''){
				toastr.success('Data Successfully Updated!');
				setTimeout(function(){
					location.reload();
				},1000)
			}else{
				toastr.error(returnData);
				$('#saveAlertModal').modal('hide');
			}
		})
		return false;
	})
});

function show(){
	tableLoader('#tba_table');
	$.post(URL+'setup/showTBA')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.tbaNo+"</td>"+
							"<td>"+a.tba+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a tbaId='"+a.id+"' class='updateTBA btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.tbaData').html(append);
		$('#tba_table').DataTable({
			    "ordering": false
		});
	})
}