<?php
/**
 * Class that operate on table 'tbl_reimbursement'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblReimbursementMySqlDAO implements TblReimbursementDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblReimbursementMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_reimbursement';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_reimbursement ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblReimbursement primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_reimbursement WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblReimbursementMySql tblReimbursement
 	 */
	public function insert($tblReimbursement){
		$sql = 'INSERT INTO tbl_reimbursement (subsync_id, subdomain, daily_forecast_id, mode_of_transpo_id, reimbursement, others_description, from, to, reimburse_date, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblReimbursement->subsyncId);
		$sqlQuery->setNumber($tblReimbursement->subdomain);
		$sqlQuery->setNumber($tblReimbursement->dailyForecastId);
		$sqlQuery->setNumber($tblReimbursement->modeOfTranspoId);
		$sqlQuery->set($tblReimbursement->reimbursement);
		$sqlQuery->set($tblReimbursement->othersDescription);
		$sqlQuery->set($tblReimbursement->from);
		$sqlQuery->set($tblReimbursement->to);
		$sqlQuery->set($tblReimbursement->reimburseDate);
		$sqlQuery->set($tblReimbursement->dateCreated);
		$sqlQuery->set($tblReimbursement->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblReimbursement->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblReimbursementMySql tblReimbursement
 	 */
	public function update($tblReimbursement){
		$sql = 'UPDATE tbl_reimbursement SET subsync_id = ?, subdomain = ?, daily_forecast_id = ?, mode_of_transpo_id = ?, reimbursement = ?, others_description = ?, from = ?, to = ?, reimburse_date = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblReimbursement->subsyncId);
		$sqlQuery->setNumber($tblReimbursement->subdomain);
		$sqlQuery->setNumber($tblReimbursement->dailyForecastId);
		$sqlQuery->setNumber($tblReimbursement->modeOfTranspoId);
		$sqlQuery->set($tblReimbursement->reimbursement);
		$sqlQuery->set($tblReimbursement->othersDescription);
		$sqlQuery->set($tblReimbursement->from);
		$sqlQuery->set($tblReimbursement->to);
		$sqlQuery->set($tblReimbursement->reimburseDate);
		$sqlQuery->set($tblReimbursement->dateCreated);
		$sqlQuery->set($tblReimbursement->dateModified);

		$sqlQuery->setNumber($tblReimbursement->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_reimbursement';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDailyForecastId($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE daily_forecast_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModeOfTranspoId($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE mode_of_transpo_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReimbursement($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE reimbursement = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOthersDescription($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE others_description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFrom($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE from = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTo($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE to = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReimburseDate($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE reimburse_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_reimbursement WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDailyForecastId($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE daily_forecast_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModeOfTranspoId($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE mode_of_transpo_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReimbursement($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE reimbursement = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOthersDescription($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE others_description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFrom($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE from = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTo($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE to = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReimburseDate($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE reimburse_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_reimbursement WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblReimbursementMySql 
	 */
	protected function readRow($row){
		$tblReimbursement = new TblReimbursement();
		
		$tblReimbursement->id = $row['id'];
		$tblReimbursement->subsyncId = $row['subsync_id'];
		$tblReimbursement->subdomain = $row['subdomain'];
		$tblReimbursement->dailyForecastId = $row['daily_forecast_id'];
		$tblReimbursement->modeOfTranspoId = $row['mode_of_transpo_id'];
		$tblReimbursement->reimbursement = $row['reimbursement'];
		$tblReimbursement->othersDescription = $row['others_description'];
		$tblReimbursement->from = $row['from'];
		$tblReimbursement->to = $row['to'];
		$tblReimbursement->reimburseDate = $row['reimburse_date'];
		$tblReimbursement->dateCreated = $row['date_created'];
		$tblReimbursement->dateModified = $row['date_modified'];

		return $tblReimbursement;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblReimbursementMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>