<?php
/**
 * Class that operate on table 'tbl_pbs_file'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblPbsFileMySqlDAO implements TblPbsFileDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblPbsFileMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_pbs_file';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_pbs_file ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblPbsFile primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_pbs_file WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPbsFileMySql tblPbsFile
 	 */
	public function insert($tblPbsFile){
		$sql = 'INSERT INTO tbl_pbs_file (subsync_id, subdomain, pbs_id, file_name, file_type, file_size, file_content, file_extension, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPbsFile->subsyncId);
		$sqlQuery->setNumber($tblPbsFile->subdomain);
		$sqlQuery->setNumber($tblPbsFile->pbsId);
		$sqlQuery->set($tblPbsFile->fileName);
		$sqlQuery->set($tblPbsFile->fileType);
		$sqlQuery->set($tblPbsFile->fileSize);
		$sqlQuery->set($tblPbsFile->fileContent);
		$sqlQuery->set($tblPbsFile->fileExtension);
		$sqlQuery->setNumber($tblPbsFile->createdBy);
		$sqlQuery->setNumber($tblPbsFile->modifiedBy);
		$sqlQuery->set($tblPbsFile->dateCreated);
		$sqlQuery->set($tblPbsFile->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblPbsFile->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPbsFileMySql tblPbsFile
 	 */
	public function update($tblPbsFile){
		$sql = 'UPDATE tbl_pbs_file SET subsync_id = ?, subdomain = ?, pbs_id = ?, file_name = ?, file_type = ?, file_size = ?, file_content = ?, file_extension = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPbsFile->subsyncId);
		$sqlQuery->setNumber($tblPbsFile->subdomain);
		$sqlQuery->setNumber($tblPbsFile->pbsId);
		$sqlQuery->set($tblPbsFile->fileName);
		$sqlQuery->set($tblPbsFile->fileType);
		$sqlQuery->set($tblPbsFile->fileSize);
		$sqlQuery->set($tblPbsFile->fileContent);
		$sqlQuery->set($tblPbsFile->fileExtension);
		$sqlQuery->setNumber($tblPbsFile->createdBy);
		$sqlQuery->setNumber($tblPbsFile->modifiedBy);
		$sqlQuery->set($tblPbsFile->dateCreated);
		$sqlQuery->set($tblPbsFile->dateModified);

		$sqlQuery->setNumber($tblPbsFile->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_pbs_file';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPbsId($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE pbs_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileName($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE file_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileType($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE file_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileSize($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE file_size = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileContent($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE file_content = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFileExtension($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE file_extension = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_pbs_file WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPbsId($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE pbs_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileName($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE file_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileType($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE file_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileSize($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE file_size = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileContent($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE file_content = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFileExtension($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE file_extension = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_pbs_file WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblPbsFileMySql 
	 */
	protected function readRow($row){
		$tblPbsFile = new TblPbsFile();
		
		$tblPbsFile->id = $row['id'];
		$tblPbsFile->subsyncId = $row['subsync_id'];
		$tblPbsFile->subdomain = $row['subdomain'];
		$tblPbsFile->pbsId = $row['pbs_id'];
		$tblPbsFile->fileName = $row['file_name'];
		$tblPbsFile->fileType = $row['file_type'];
		$tblPbsFile->fileSize = $row['file_size'];
		$tblPbsFile->fileContent = $row['file_content'];
		$tblPbsFile->fileExtension = $row['file_extension'];
		$tblPbsFile->createdBy = $row['created_by'];
		$tblPbsFile->modifiedBy = $row['modified_by'];
		$tblPbsFile->dateCreated = $row['date_created'];
		$tblPbsFile->dateModified = $row['date_modified'];

		return $tblPbsFile;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblPbsFileMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>