<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-04-03 07:16
 */
interface TblUserSignatureDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblUserSignature 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblUserSignature primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserSignature tblUserSignature
 	 */
	public function insert($tblUserSignature);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserSignature tblUserSignature
 	 */
	public function update($tblUserSignature);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByFileName($value);

	public function queryByFileType($value);

	public function queryByFileSize($value);

	public function queryByFileDirectory($value);

	public function queryByFileContent($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByUserId($value);

	public function deleteByFileName($value);

	public function deleteByFileType($value);

	public function deleteByFileSize($value);

	public function deleteByFileDirectory($value);

	public function deleteByFileContent($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>