<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-01-16 03:29
 */
interface TblRatePerPositionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblRatePerPosition 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblRatePerPosition primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblRatePerPosition tblRatePerPosition
 	 */
	public function insert($tblRatePerPosition);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblRatePerPosition tblRatePerPosition
 	 */
	public function update($tblRatePerPosition);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubdomain($value);

	public function queryByPositionId($value);

	public function queryByRate($value);

	public function queryByType($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubdomain($value);

	public function deleteByPositionId($value);

	public function deleteByRate($value);

	public function deleteByType($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>