<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblForecastTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblForecastTransaction 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblForecastTransaction primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblForecastTransaction tblForecastTransaction
 	 */
	public function insert($tblForecastTransaction);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblForecastTransaction tblForecastTransaction
 	 */
	public function update($tblForecastTransaction);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByForecastId($value);

	public function queryByClientId($value);

	public function queryByEngagementId($value);

	public function queryByTbaId($value);

	public function queryByNbtId($value);

	public function queryByRank($value);

	public function queryByTarget($value);

	public function queryByBudgetHrs($value);

	public function queryByToDoDate($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByForecastId($value);

	public function deleteByClientId($value);

	public function deleteByEngagementId($value);

	public function deleteByTbaId($value);

	public function deleteByNbtId($value);

	public function deleteByRank($value);

	public function deleteByTarget($value);

	public function deleteByBudgetHrs($value);

	public function deleteByToDoDate($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>