<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblDailyForecastDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDailyForecast 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDailyForecast primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDailyForecast tblDailyForecast
 	 */
	public function insert($tblDailyForecast);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDailyForecast tblDailyForecast
 	 */
	public function update($tblDailyForecast);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByUserId($value);

	public function queryByForecastTransactionId($value);

	public function queryByToDoDate($value);

	public function queryByHourCode($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByUserId($value);

	public function deleteByForecastTransactionId($value);

	public function deleteByToDoDate($value);

	public function deleteByHourCode($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>