<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-19 03:35
 */
interface TblAllowanceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblAllowance 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblAllowance primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblAllowance tblAllowance
 	 */
	public function insert($tblAllowance);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblAllowance tblAllowance
 	 */
	public function update($tblAllowance);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProvinceId($value);

	public function queryByMeal($value);

	public function queryByTranspo($value);

	public function queryByMealExcess($value);

	public function queryByTranspo_excess($value);

	public function queryByMinimumHrs($value);

	public function queryByExcessHrs($value);

	public function queryByStatus($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByProvinceId($value);

	public function deleteByMeal($value);

	public function deleteByTranspo($value);

	public function deleteByMealExcess($value);

	public function deleteByTranspo_excess($value);

	public function deleteByMinimumHrs($value);

	public function deleteByExcessHrs($value);

	public function deleteByStatus($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>