<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblEmployeeDirectoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblEmployeeDirectory 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblEmployeeDirectory primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEmployeeDirectory tblEmployeeDirectory
 	 */
	public function insert($tblEmployeeDirectory);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEmployeeDirectory tblEmployeeDirectory
 	 */
	public function update($tblEmployeeDirectory);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByPhoneNo($value);

	public function queryByNetwork($value);

	public function queryByCreatedAt($value);

	public function queryByUpdatedAt($value);


	public function deleteByUserId($value);

	public function deleteByPhoneNo($value);

	public function deleteByNetwork($value);

	public function deleteByCreatedAt($value);

	public function deleteByUpdatedAt($value);


}
?>