<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblClientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblClient 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblClient primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClient tblClient
 	 */
	public function insert($tblClient);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClient tblClient
 	 */
	public function update($tblClient);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientName($value);


	public function deleteByClientName($value);


}
?>