$(function(){
	show();
	countTable('setup/countEngType','ETP-','#formEngType','input[name="eng_type_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formEngType').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveEngType', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#eng_type_table').on('click','.updateEngType',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('engTypeId');
		var eng_type_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var eng_type = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateEngType').find('input[name="eng_type_id"]').val(id);
		$('#updateEngType').find('input[name="eng_type_no"]').val(eng_type_no);
		$('#updateEngType').find('input[name="eng_type"]').val(eng_type);

		if(status == 'enabled'){
			$('#updateEngType').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateEngType').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateEngType').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateEngType', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#eng_type_table');
	$.post(URL+'setup/showEngType')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.engTypeNo+"</td>"+
							"<td>"+a.engType+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a engTypeId='"+a.id+"' class='updateEngType btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";
		});
		$('.engTypeData').html(append);
		$('#eng_type_table').DataTable({
			    "ordering": false
		});
	})
}