<?php
/**
 * Class that operate on table 'tbl_request_ot'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblRequestOtMySqlDAO implements TblRequestOtDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblRequestOtMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_request_ot WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_request_ot';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_request_ot ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblRequestOt primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_request_ot WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblRequestOtMySql tblRequestOt
 	 */
	public function insert($tblRequestOt){
		$sql = 'INSERT INTO tbl_request_ot (subsync_id, subdomain, user_id, approver_id, forecast_transaction_id, from_hours, to_hours, estimated_hours, reason, status, date_requested, date_approved, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblRequestOt->subsyncId);
		$sqlQuery->setNumber($tblRequestOt->subdomain);
		$sqlQuery->setNumber($tblRequestOt->userId);
		$sqlQuery->setNumber($tblRequestOt->approverId);
		$sqlQuery->setNumber($tblRequestOt->forecastTransactionId);
		$sqlQuery->set($tblRequestOt->fromHours);
		$sqlQuery->set($tblRequestOt->toHours);
		$sqlQuery->set($tblRequestOt->estimatedHours);
		$sqlQuery->set($tblRequestOt->reason);
		$sqlQuery->set($tblRequestOt->status);
		$sqlQuery->set($tblRequestOt->dateRequested);
		$sqlQuery->set($tblRequestOt->dateApproved);
		$sqlQuery->setNumber($tblRequestOt->createdBy);
		$sqlQuery->setNumber($tblRequestOt->modifiedBy);
		$sqlQuery->set($tblRequestOt->dateCreated);
		$sqlQuery->set($tblRequestOt->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblRequestOt->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblRequestOtMySql tblRequestOt
 	 */
	public function update($tblRequestOt){
		$sql = 'UPDATE tbl_request_ot SET subsync_id = ?, subdomain = ?, user_id = ?, approver_id = ?, forecast_transaction_id = ?, from_hours = ?, to_hours = ?, estimated_hours = ?, reason = ?, status = ?, date_requested = ?, date_approved = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblRequestOt->subsyncId);
		$sqlQuery->setNumber($tblRequestOt->subdomain);
		$sqlQuery->setNumber($tblRequestOt->userId);
		$sqlQuery->setNumber($tblRequestOt->approverId);
		$sqlQuery->setNumber($tblRequestOt->forecastTransactionId);
		$sqlQuery->set($tblRequestOt->fromHours);
		$sqlQuery->set($tblRequestOt->toHours);
		$sqlQuery->set($tblRequestOt->estimatedHours);
		$sqlQuery->set($tblRequestOt->reason);
		$sqlQuery->set($tblRequestOt->status);
		$sqlQuery->set($tblRequestOt->dateRequested);
		$sqlQuery->set($tblRequestOt->dateApproved);
		$sqlQuery->setNumber($tblRequestOt->createdBy);
		$sqlQuery->setNumber($tblRequestOt->modifiedBy);
		$sqlQuery->set($tblRequestOt->dateCreated);
		$sqlQuery->set($tblRequestOt->dateModified);

		$sqlQuery->setNumber($tblRequestOt->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_request_ot';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproverId($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByForecastTransactionId($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE forecast_transaction_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFromHours($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE from_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToHours($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE to_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEstimatedHours($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE estimated_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReason($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE reason = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateRequested($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE date_requested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateApproved($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE date_approved = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproverId($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByForecastTransactionId($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE forecast_transaction_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFromHours($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE from_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToHours($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE to_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEstimatedHours($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE estimated_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReason($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE reason = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateRequested($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE date_requested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateApproved($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE date_approved = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblRequestOtMySql 
	 */
	protected function readRow($row){
		$tblRequestOt = new TblRequestOt();
		
		$tblRequestOt->id = $row['id'];
		$tblRequestOt->subsyncId = $row['subsync_id'];
		$tblRequestOt->subdomain = $row['subdomain'];
		$tblRequestOt->userId = $row['user_id'];
		$tblRequestOt->approverId = $row['approver_id'];
		$tblRequestOt->forecastTransactionId = $row['forecast_transaction_id'];
		$tblRequestOt->fromHours = $row['from_hours'];
		$tblRequestOt->toHours = $row['to_hours'];
		$tblRequestOt->estimatedHours = $row['estimated_hours'];
		$tblRequestOt->reason = $row['reason'];
		$tblRequestOt->status = $row['status'];
		$tblRequestOt->dateRequested = $row['date_requested'];
		$tblRequestOt->dateApproved = $row['date_approved'];
		$tblRequestOt->createdBy = $row['created_by'];
		$tblRequestOt->modifiedBy = $row['modified_by'];
		$tblRequestOt->dateCreated = $row['date_created'];
		$tblRequestOt->dateModified = $row['date_modified'];

		return $tblRequestOt;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblRequestOtMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>