<?php
	if(!($this->data)){
?>
		<input type="hidden" name="counts" class="toRemove" value="20"/>
		<input type="hidden" name="page" value="1"/>
<?php
		echo 'No database found!';
		exit;
	}
	$lists = $this->listAll;
	$pages = count($lists) / $_POST['counts'];
	
	$array = explode('.',$pages);
	$pages = isset($array[1]) ? $array[0] + 1 : $array[0];
?>
<div class="row">
	<div class="col-xs-12">
		<div class="form-group">
			<div class="col-xs-3">
				<div class="input-group">
					<input type="number" name="counts" class="form-control" value="<?= $_POST['counts'] ?>"/>
					<span class="input-group-addon">/<?= count($lists) ?></span>
				</div>
			</div>
			<div class="col-xs-2">
				<select name="page" class="form-control">
					<?php for($n = 1; $n <= $pages; $n++): ?>
						<option <?= $n == $_POST['page'] ? 'selected' : '' ?>><?=$n?></option>
					<?php endfor; ?>
				</select>
			</div>
			<?php if(isset($_POST['ub']) && $_POST['ub'] != '%%' && $_POST['status'] != 'queue'):?>
				<div class="col-xs-7 text-right">
					<!--button ubType="<?=$_POST['ub']?>" class="btn btn-success-standard update-all-db">Update All</button-->
					<button ubType="<?=$_POST['ub']?>" class="btn btn-success-standard go-update">Update All</button>
				</div>
			<?php endif;?>
			<div class="clearfix"></div>
		</div>
		
		
		<div class="col-xs-12">
			<table class="table table-bordered">
				<tr>
					<th>Databases Name</th>
					<th>Type</th>
					<th>Version</th>
					<th>Created</th>
					<th>Used</th>
					<th class="text-center">Status</th>
				</tr>
				
				<?php foreach($this->data as $var=>$each){ ?>
					<tr class="<?php if($each->status == 'available'){echo 'bg-success';}elseif($each->status == 'used'){echo 'bg-danger';}?>">
						<td><?= $each->databaseName ?></td>
						<td><?= $each->ub ?></td>
						<td><?=$each->version?></td>
						<td><?= date('F d, Y H:i',strtotime($each->dateCreated)) ?></td>
						<td><?= $each->dateUsed == '0000-00-00 00:00:00' ? '' : date('F d, Y H:i',strtotime($each->dateUsed)) ?></td>
						<td>
							<?php 
								if($each->status == 'queue'){
						?>
							<input class="btn btn-success-standard updateDatabase" type="button" dbName="<?= $each->databaseName ?>" dbType="<?= $each->ub ?>" value="Activate" title="Queue"/>
						<?php
								} else {
									echo $each->status;
						?>
									 <button dbName="<?= $each->databaseName ?>" dbType="<?= $each->ub ?>" class="btn btn-success-standard alterDb">Update</button>
						<?php
								}
							?>
						</td>
					</tr>
				<?php } ?>
			</table>
		</div>
	</div>
</div>

<script>
	var ubType = '';
	$(function(){
		
		goUpdateAll();
		$('.alterDb').click(function(){
			
			type = $(this).attr('dbType');
			databaseName = $(this).attr('dbName');
			$('.cssload-holder').css('opacity','1');
			
			$.post(URL+'report/modifyDb',{'type':type,'name':databaseName})
				.done(function(returnData){
					if(returnData == '')
					{
					
						openAlert('.successAlert');
						setTimeout(closeAlert,3000);
						$('#searchDb').submit();							
					}
					else
					{
						$('.errorAlert .alert-content').html(returnData);
						openAlert('.errorAlert');
						setTimeout(closeAlert,3000);
					}
					$('.cssload-holder').css('opacity','0');
				});
		});
	
		$('.updateDatabase').click(function(){
		
			type = $(this).attr('dbType');
			databaseName = $(this).attr('dbName');
			
			$('#cofirmCreateDatabase').modal('toggle');
			$('#cofirmCreateDatabase .modal-body .modal-body-content').html('Are you sure you want to load database: '+databaseName+' ?');
			
			// confirmLoad = confirm('Are you sure you want to load database:'+databaseName+'?');
			
			$('.confirmCreate').click(function(){
				$('.cssload-holder').css('opacity','1');
				$.post('<?= URL ?>api/'+type+'/loadNewDatabase',{'name':databaseName})
					.done(function(returnData){
					
						$('#cofirmCreateDatabase').modal('toggle');
						if(returnData == '')
						{
						
							openAlert('.successAlert');
							setTimeout(closeAlert,3000);
							
							$('#searchDb').submit();							
						}
						else
						{
							$('.errorAlert .alert-content').html(returnData);
							openAlert('.errorAlert');
							setTimeout(closeAlert,3000);
						}
						$('.cssload-holder').css('opacity','0');
					});
				return false;				
			})
		});
		
		$('.update-all-db').click(function(){
			var that = $(this);
			 ubType = that.attr('ubType');
			$('.cssload-holder').css('opacity','1');
			$('#updateAllConfirm').modal('toggle');
			updateAllDb(ubType);
		});
	});
	
	function goUpdateAll()
	{
		$('.go-update').unbind('click');
		$('.go-update').bind('click',function(){
			$('.cssload-holder').css('opacity','1');
			$('.alterDb').closest('td').append('<i class="fa fa-spin fa-refresh"></i>');
			
			$('.alterDb').each(function(){
				var that = $(this);
				var type = that.attr('dbType');
				var databaseName = that.attr('dbName');
				
				// setTimeout(function(){
					alterDatabase(type,databaseName,that);
				// },2000);
			});
			
			$('.cssload-holder').css('opacity','0');
			goUpdateAll();
		});
	}
	
	function alterDatabase(type,databaseName,btn)
	{
		$.post(URL+'report/modifyDb',{'type':type,'name':databaseName})
			.done(function(returnData){
				if(returnData == '')
				{
					openAlert('.successAlert');
					setTimeout(closeAlert,3000);	
					btn.closest('td').find('i').removeClass('fa fa-spin fa-refresh').addClass('pe-7s-check');
				}
				else
				{
					$('.errorAlert .alert-content').html(returnData);
					openAlert('.errorAlert');
					setTimeout(closeAlert,3000);
				}
				
			});
	}
	
	function updateAllDb(ubType)
	{
		$('.response-button').unbind('click');
		$('.response-button').bind('click',function(){
			var that = $(this);
			var response = that.attr('id');
			
			if(response == 'confirm-update')
			{
				that.prop('disabled',true);
				$('.response-group').addClass('hidden');
				$('.modal-icon-notif').html('<i class="fa fa-refresh fa-spin"></i>');
				$('#updateAllConfirm .modal-body-content').html('Updating all databases... Please wait.'+
																	'<br/>Do not close or refresh your browser.'+
																	'<br/> It may cause error to your databases.<br/>');
				$('#updateAllConfirm').off('click');
				$('#updateAllConfirm').css('cursor','wait');
				
				$.post(URL+'report/modifyAllDb',{'type':ubType})
					.done(function(result){
						$('#updateAllConfirm .modal-body-content').append('This page will be refresh in <span class="close-warning">3</span>');
						// alert(result);
						// return false;
						// $('#updateAllConfirm').modal('hide')
						if(result == '')
						{
							openAlert('.successAlert');
							
						}
						else
						{
							$('.errorAlert .alert-content').html(result);
							openAlert('.errorAlert');
							
						}
						
						$('.cssload-holder').css('opacity','0');
						var i = parseInt($('.close-warning').text());
						setInterval(function(){
								if(i != 0)
								{
									i--;
									$('.close-warning').html(i);
								}
								else
								{
									location.reload();
								}
						},1000)
					});
			}
		});
	}
	
	function openAlert(classError)
	{
		$('.alert-notification'+classError).css('opacity',1);
		$('.alert-notification'+classError).css('right','300px');
	}
	function closeAlert()
	{
		$('.alert-notification').css('opacity',0);
		$('.alert-notification').css('right','130px');
	}

	function closeAlertBtn()
	{
		$('.close-alert').click(function(){
			$(this).closest('.alert-notification').css('opacity',0);
			$(this).closest('.alert-notification').css('right','130px');
		})
	}
</script>