<?php
	$users  = $this->user;
	$admin = Session::getSession('userDbUser');
?>
<style>
	
</style>
<div class="row">
	<div class="col-xs-4">
		<div class="panel panel-default">
			<div class="panel-heading">
				<i class="pe-7s-add-user pe-lg"></i>
				Create User
			</div>
			<div class="panel-body">
				<form method="POST" id="createUser">
					<div class="form-group col-xs-12">
						<label>Username:</label> 
						<input type="text" name="username" required class="form-control" />
					</div>
					<div class="form-group col-xs-12">
						<label>Password:</label> 
						<input type="password" name="password" required class="form-control" />
					</div>
					<div class="form-group col-xs-12">
						<label>Type:</label> 
						<select name="status" required class="form-control">
							<option selected disabled>Select Status</option>
							<option value="admin">Admin</option>
							<option value="developer">Developer</option>
						</select>
					</div>
					<div class="form-group col-xs-12">
						<input type="submit" class="form-control btn btn-success-standard" value="SUBMIT"/>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="col-xs-8 <?=$admin['status'] == 'admin' ? '' : 'hidden'?>">
		<div class="panel panel-default">
			<div class="panel-heading">
				<i class="pe-7s-users pe-lg"></i>
				Users
			</div>
			<div class="panel-body">
				<div class="form-group">
					<table class="table table-default">
						<thead>
							<tr>
								<th>#</th>
								<th>Username</th>
								<th>Password</th>
								<th>Status</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach($users as $each):?>
								<tr>
									<td><?=$each->id;?></td>
									<td><?=$each->username;?></td>
									<td><?=$each->password;?></td>
									<td><?=$each->status;?></td>
								</tr>
							<?php endforeach;?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	<div class="clearfix"></div>
</div>


<script>
	$(function(){
		$('#createUser').submit(function(){
			
			$('.cssload-holder').css('opacity','1');
			
			$.post(URL+'index/submit_user',$(this).serialize())
			.done(function(returnData){
				
				if(returnData == '')
				{
					$('.successAlert .alert-content').html('Creation of user success.');
					openAlert('.successAlert');
					setTimeout(closeAlert,3000);
				}
				else
				{
					$('.errorAlert .alert-content').html(returnData);
					openAlert('.errorAlert');
					setTimeout(closeAlert,3000);
				}
				
				$('.cssload-holder').css('opacity','0');
				
			})
			return false;
		})
	})
</script>