-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.1.26-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win32
-- HeidiSQL Version:             9.4.0.5173
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table dashmentor_v2.tbl_attached_documents
CREATE TABLE IF NOT EXISTS `tbl_attached_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `file_name` varchar(1000) NOT NULL,
  `file_type` varchar(1000) NOT NULL,
  `file_size` varchar(1000) NOT NULL,
  `file_content` longblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `cm_id.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table dashmentor_v2.tbl_attached_documents: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_attached_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_attached_documents` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_client
CREATE TABLE IF NOT EXISTS `tbl_client` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_name` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_client: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_client` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_client` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_client_and_engagement
CREATE TABLE IF NOT EXISTS `tbl_client_and_engagement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `engagement_list_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `engagement_list_id` (`engagement_list_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `tcam_id.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_client_and_engagement: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_client_and_engagement` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_client_and_engagement` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_client_feedback
CREATE TABLE IF NOT EXISTS `tbl_client_feedback` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `client` varchar(250) NOT NULL,
  `feedback` varchar(250) NOT NULL,
  `grade` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `cnm_formId.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table dashmentor_v2.tbl_client_feedback: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_client_feedback` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_client_feedback` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_client_list
CREATE TABLE IF NOT EXISTS `tbl_client_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subordinate_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `subordinate_id` (`subordinate_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_client_list: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_client_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_client_list` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_coaching_and_mentoring
CREATE TABLE IF NOT EXISTS `tbl_coaching_and_mentoring` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subordinate_id` int(11) NOT NULL,
  `for_the_month` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `dpr_submitted_on_time` enum('yes','no') NOT NULL,
  `other_required_reports_on_time` enum('yes','no') NOT NULL,
  `planned_paid_leave` varchar(50) NOT NULL,
  `planned_absences_without_pay` varchar(50) NOT NULL,
  `date_today` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mentoring_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `next_meeting` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `staff_signature` longblob NOT NULL,
  `coach_recommendation` text NOT NULL,
  `coach_signature` longblob NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `subordinate_id` (`subordinate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_coaching_and_mentoring: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_coaching_and_mentoring` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_coaching_and_mentoring` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_committed_improvements
CREATE TABLE IF NOT EXISTS `tbl_committed_improvements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `committed_improvements` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `form_id.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table dashmentor_v2.tbl_committed_improvements: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_committed_improvements` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_committed_improvements` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_engagement
CREATE TABLE IF NOT EXISTS `tbl_engagement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `engagement` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_engagement: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_engagement` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_engagement` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_engagement_list
CREATE TABLE IF NOT EXISTS `tbl_engagement_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_list_id` int(11) NOT NULL,
  `engagement_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `client_list_id` (`client_list_id`),
  KEY `engagement_id` (`engagement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_engagement_list: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_engagement_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_engagement_list` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_key_accomplishments
CREATE TABLE IF NOT EXISTS `tbl_key_accomplishments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `key_accomplishments` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_3` (`coaching_and_mentoring_id`),
  CONSTRAINT `coach_form.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_key_accomplishments: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_key_accomplishments` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_key_accomplishments` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_key_soft_skills_weakness
CREATE TABLE IF NOT EXISTS `tbl_key_soft_skills_weakness` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `key_soft_skills_weakness` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `form.ibfk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table dashmentor_v2.tbl_key_soft_skills_weakness: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_key_soft_skills_weakness` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_key_soft_skills_weakness` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_key_technical_skills
CREATE TABLE IF NOT EXISTS `tbl_key_technical_skills` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `key_technical_skills` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_3` (`coaching_and_mentoring_id`),
  CONSTRAINT `form_id.ibfk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table dashmentor_v2.tbl_key_technical_skills: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_key_technical_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_key_technical_skills` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_key_technical_weakness
CREATE TABLE IF NOT EXISTS `tbl_key_technical_weakness` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `key_technical_weakness` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `coach_formId.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table dashmentor_v2.tbl_key_technical_weakness: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_key_technical_weakness` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_key_technical_weakness` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_steps
CREATE TABLE IF NOT EXISTS `tbl_steps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `step_1` enum('Yes','No') NOT NULL,
  `step_2` enum('Yes','No') NOT NULL,
  `step_2_how_many` text NOT NULL,
  `step_3` enum('Yes','No') NOT NULL,
  `step_3_why` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `formId.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_steps: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_steps` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_steps` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_step_1_specify_services
CREATE TABLE IF NOT EXISTS `tbl_step_1_specify_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `steps_id` int(11) NOT NULL,
  `specify_services` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `steps_id` (`steps_id`),
  KEY `steps_id_2` (`steps_id`),
  CONSTRAINT `step1.fk` FOREIGN KEY (`steps_id`) REFERENCES `tbl_steps` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_step_1_specify_services: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_step_1_specify_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_step_1_specify_services` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_subordinate
CREATE TABLE IF NOT EXISTS `tbl_subordinate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coach_id` int(11) NOT NULL,
  `subordinate_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_subordinate: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_subordinate` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subordinate` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_target_referrals
CREATE TABLE IF NOT EXISTS `tbl_target_referrals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `monthly_target` varchar(50) NOT NULL DEFAULT '5',
  `actual` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coach_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  CONSTRAINT `coaching_form_id.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_target_referrals: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_target_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_target_referrals` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_target_revenue
CREATE TABLE IF NOT EXISTS `tbl_target_revenue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `annual_target` varchar(50) NOT NULL,
  `actual_year_to_date` varchar(50) NOT NULL,
  `monthly_target` varchar(50) NOT NULL,
  `actual_month_to_date` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `cf_id.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_target_revenue: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_target_revenue` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_target_revenue` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_top_3_progress
CREATE TABLE IF NOT EXISTS `tbl_top_3_progress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coaching_and_mentoring_id` int(11) NOT NULL,
  `top_3_progress` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coaching_and_mentoring_id` (`coaching_and_mentoring_id`),
  KEY `coaching_and_mentoring_id_2` (`coaching_and_mentoring_id`),
  CONSTRAINT `cnm_id.fk` FOREIGN KEY (`coaching_and_mentoring_id`) REFERENCES `tbl_coaching_and_mentoring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table dashmentor_v2.tbl_top_3_progress: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_top_3_progress` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_top_3_progress` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_user
CREATE TABLE IF NOT EXISTS `tbl_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dash_user_id` int(11) NOT NULL,
  `user_name` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `registration_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_user: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user` ENABLE KEYS */;

-- Dumping structure for table dashmentor_v2.tbl_user_info
CREATE TABLE IF NOT EXISTS `tbl_user_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `middle_name` varchar(50) NOT NULL,
  `position` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_id_2` (`user_id`),
  CONSTRAINT `user_id.fk` FOREIGN KEY (`user_id`) REFERENCES `tbl_user` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table dashmentor_v2.tbl_user_info: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_user_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_info` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
