<?php
/**
 * Class that operate on table 'tbl_database_list'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-03-21 01:40
 */
class TblDatabaseListMySqlDAO implements TblDatabaseListDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDatabaseListMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_database_list WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_database_list';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_database_list ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDatabaseList primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_database_list WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDatabaseListMySql tblDatabaseList
 	 */
	public function insert($tblDatabaseList){
		$sql = 'INSERT INTO tbl_database_list (ub, database_name, status, date_created, date_used, version) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblDatabaseList->ub);
		$sqlQuery->set($tblDatabaseList->databaseName);
		$sqlQuery->set($tblDatabaseList->status);
		$sqlQuery->set($tblDatabaseList->dateCreated);
		$sqlQuery->set($tblDatabaseList->dateUsed);
		$sqlQuery->set($tblDatabaseList->version);

		$id = $this->executeInsert($sqlQuery);	
		$tblDatabaseList->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDatabaseListMySql tblDatabaseList
 	 */
	public function update($tblDatabaseList){
		$sql = 'UPDATE tbl_database_list SET ub = ?, database_name = ?, status = ?, date_created = ?, date_used = ?, version = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($tblDatabaseList->ub);
		$sqlQuery->set($tblDatabaseList->databaseName);
		$sqlQuery->set($tblDatabaseList->status);
		$sqlQuery->set($tblDatabaseList->dateCreated);
		$sqlQuery->set($tblDatabaseList->dateUsed);
		$sqlQuery->set($tblDatabaseList->version);

		$sqlQuery->setNumber($tblDatabaseList->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_database_list';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUb($value){
		$sql = 'SELECT * FROM tbl_database_list WHERE ub = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDatabaseName($value){
		$sql = 'SELECT * FROM tbl_database_list WHERE database_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_database_list WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_database_list WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateUsed($value){
		$sql = 'SELECT * FROM tbl_database_list WHERE date_used = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByVersion($value){
		$sql = 'SELECT * FROM tbl_database_list WHERE version = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUb($value){
		$sql = 'DELETE FROM tbl_database_list WHERE ub = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDatabaseName($value){
		$sql = 'DELETE FROM tbl_database_list WHERE database_name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_database_list WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_database_list WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateUsed($value){
		$sql = 'DELETE FROM tbl_database_list WHERE date_used = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByVersion($value){
		$sql = 'DELETE FROM tbl_database_list WHERE version = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDatabaseListMySql 
	 */
	protected function readRow($row){
		$tblDatabaseList = new TblDatabaseList();
		
		$tblDatabaseList->id = $row['id'];
		$tblDatabaseList->ub = $row['ub'];
		$tblDatabaseList->databaseName = $row['database_name'];
		$tblDatabaseList->status = $row['status'];
		$tblDatabaseList->dateCreated = $row['date_created'];
		$tblDatabaseList->dateUsed = $row['date_used'];
		$tblDatabaseList->version = $row['version'];

		return $tblDatabaseList;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDatabaseListMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>